function NavObjectiveMap()
{
	this.objRef = null;
	this.read = null;
	this.write = null;
	
	this.setDefaultValues();
}
NavObjectiveMap.prototype.loadFromXMLNode = NavObjectiveMapLoadFromXMLNode;
NavObjectiveMap.prototype.setDefaultValues = NavObjectiveMapSetDefaultValues;

function NavObjectiveMapSetDefaultValues()
{
	this.objRef = null;
	this.read = true;
	this.write = false;
}

function NavObjectiveMapLoadFromXMLNode(xmlNode)
{
	this.setDefaultValues();

	var temp;
	
	this.objRef = xmlNode.getAttribute("refId").toLowerCase();

	temp = xmlNode.getAttribute("read");
	if (temp == null || temp.toLowerCase() == "true")
	{
		this.read = true;
	}
	else
	{
		this.read = false;
	}

	temp = xmlNode.getAttribute("write");
	if (temp.toLowerCase() == "true")
	{
		this.write = true;
	}
	else
	{
		this.write = false;
	}
}
